<?php
/**
 * Transfer Character
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<h1 class="page-header">Transfer Character Logs</h1>';

$TransferCharacter = new \Plugin\TransferCharacter\TransferCharacter();
if(!check_value($_GET['limit'])) {
	$_GET['limit'] = 50;
}
$logs = $TransferCharacter->getTransferLogs($_GET['limit']);

echo '<div class="row">';

	echo '<div class="col-md-12">';

		if(is_array($logs)) {
			
			echo '<h3>Showing '.($_GET['limit'] == 0 ? 'All' : 'Last ' . $_GET['limit']).' Logs:</h3>';
			echo 'Limit: ';
			echo '<a href="?module=transfercharacter&page=logs&limit=50">50</a> | ';
			echo '<a href="?module=transfercharacter&page=logs&limit=100">100</a> | ';
			echo '<a href="?module=transfercharacter&page=logs&limit=200">200</a> | ';
			echo '<a href="?module=transfercharacter&page=logs&limit=500">500</a> | ';
			echo '<a href="?module=transfercharacter&page=logs&limit=0">All</a><br /><br />';
			
			echo '<table class="table table-condensed table-hover">';
			echo '<thead>';
				echo '<tr>';
					echo '<th>Id</th>';
					echo '<th>Transfer Date</th>';
					echo '<th>Original Owner</th>';
					echo '<th>New Owner</th>';
					echo '<th>Chracter</th>';
				echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
			foreach($logs as $row) {
				echo '<tr>';
					echo '<td>'.$row['id'].'</td>';
					echo '<td>'.$row['transfer_date'].'</td>';
					echo '<td>'.$row['original_owner_username'].'</td>';
					echo '<td>'.$row['new_owner_username'].'</td>';
					echo '<td>'.$row['character_name'].'</td>';
				echo '</tr>';
			}
			echo '
			</tbody>
			</table>';
		} else {
			message('warning', 'There are no logs to display.');
		}
		
	echo '</div>';
echo '</div>';